/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ntfy;

import com.ibm.hwmca.fw.ntfy.DescriptiveObject;
import com.ibm.hwmca.fw.task.UserContext;
import java.io.Serializable;
import java.util.Calendar;
import java.util.EventObject;

public class TimeFilter
extends DescriptiveObject
implements Serializable {
    static final long serialVersionUID = -4802927383043941318L;
    private static final String TRACE_MASKT = "XNTYTFIT";
    private static final String TRACE_MASKF = "XNTYTFIF";
    private static final String TRACE_MASKD = "XNTYTFID";
    int[] _days;
    Calendar _startTime;
    Calendar _stopTime;
    Calendar _startDay;
    Calendar _stopDay;

    TimeFilter() {
    }

    public TimeFilter(String name, String description, int[] days, Calendar startTime, Calendar stopTime, Calendar startDay, Calendar stopDay) {
        super(name, description);
        this._days = days;
        this._startTime = startTime;
        this._stopTime = stopTime;
        this._startDay = startDay;
        this._stopDay = stopDay;
    }

    public boolean pass(EventObject event) {
        UserContext userContext = UserContext.getCurrentUserContext();
        Calendar now = Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale());
        return this.rightDay(now.get(7)) && this.rightDate(now) && this.rightTime(now.get(11), now.get(12));
    }

    private boolean rightTime(int hours, int minutes) {
        if (this._startTime == null) {
            return true;
        }
        int nowMinutes = 60 * hours + minutes;
        int startMinutes = 60 * this._startTime.get(11) + this._startTime.get(12);
        int stopMinutes = 60 * this._stopTime.get(11) + this._stopTime.get(12);
        return startMinutes <= nowMinutes && nowMinutes <= stopMinutes;
    }

    private boolean rightDate(Calendar date) {
        if (this._startDay == null) {
            return true;
        }
        return this._startDay.before(date) && this._stopDay.after(date);
    }

    private boolean rightDay(int dayOfWeek) {
        for (int i = 0; i < this._days.length; ++i) {
            if (this._days[i] != dayOfWeek) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getClass().getName());
        buff.append("[ ");
        buff.append("days=");
        buff.append(this._days);
        buff.append("startTime=");
        buff.append(this._startTime == null ? "null" : this._startTime.toString());
        buff.append(", stopTime=");
        buff.append(this._stopTime == null ? "null" : this._stopTime.toString());
        buff.append(", startDay=");
        buff.append(this._startDay == null ? "null" : this._startDay.toString());
        buff.append(", stopDay=");
        buff.append(this._stopDay == null ? "null" : this._stopDay.toString());
        buff.append(" ]");
        return buff.toString();
    }

    public int[] getDays() {
        return this._days;
    }

    public Calendar getStartDay() {
        return this._startDay;
    }

    public Calendar getStopDay() {
        return this._stopDay;
    }

    public Calendar getStartTime() {
        return this._startTime;
    }

    public Calendar getStopTime() {
        return this._stopTime;
    }
}

